﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Timers;
using System.Windows.Forms;
using System.Diagnostics;
using InSimDotNet;
using InSimDotNet.Packets;
using MySql.Data.MySqlClient;

namespace Dizplay_Cruise
{
    public partial class Dizplay : Form
    {
        public delegate void ControlSetCallback(Control control);
        public delegate void ControlTextCallback(Control control, string text);
        public delegate void ControlRtfCallback(Control control, string rtf);
        public delegate string ControlGetRtfCallback(Control control);
        public delegate void ControlItemsAddCallback(Control control, object item);
        public static InSimClient InSim = new InSimClient();
        public static List<clsUser> Users = new List<clsUser>();
        public static List<clsHistory> History = new List<clsHistory>();
        public static List<Button.clsSequence> Sequences = new List<Button.clsSequence>();

        public static InSimSettings iSettings = new InSimSettings
        {
            Host = "127.0.0.1",
            Port = 29009,
            Admin = "wisdomtorch",

            Flags = InSimFlags.MultiCarInfo | InSimFlags.Contact | InSimFlags.ObjectHit | InSimFlags.HotLapValidity | InSimFlags.AutoXEdit,
            Interval = Globals.rootInterval,
            Prefix = '!',
            Name = "^1Dizplay"
        };

        // CTControl = Cross Thread Control
        public static Control CTControl;

        System.Timers.Timer MemoryClock = new System.Timers.Timer();
        public Dizplay()
        {
            InitializeComponent();
            Processor.HistoryAdd("History control is alive", " You heard it here first!");

            try
            {
                InSim.Initialized += InSim_Initialized;
                InSim.Disconnected += InSim_Disconnected;
                InSim.InSimError += InSim_InSimError;

                MemoryClock.Elapsed += new ElapsedEventHandler(MemoryClock_Elapsed);
                MemoryClock.Interval = 1000;
                MemoryClock.Start();
                MemoryClock.Enabled = true;
            }
            catch (Exception E)
            {
                Processor.ErrorRecord(E);
            }
        }

        void InSim_Disconnected(object sender, EventArgs e)
        {
            Processor.HistoryAdd("InSim has disconnected", "Reinitializing process started.");
            InSim.Initialize(iSettings);
        }

        // InSim event handlers START

        void InSim_Initializing(object sender, InitializeEventArgs e)
        {
            string Title = "InSim is initializing";
            string Text =
                "Initialization process started." + Globals.nl +
                "   --> IP: " + e.Settings.Host + Globals.nl +
                "   --> Port: " + e.Settings.Port + Globals.nl +
                "   --> UDP Port: " + e.Settings.UdpPort + Globals.nl +
                "   --> IName: " + e.Settings.Name + Globals.nl +
                "   --> Interval: " + e.Settings.Interval + Globals.nl +
                "   --> Flags: " + e.Settings.Flags;

            Processor.HistoryAdd(Title, Text);
        }

        void InSim_Initialized(object sender, InitializeEventArgs e)
        {
            string Title = "InSim initialized";
            string Text =
                "Initialization process completed." + Globals.nl +
                "   --> IP: " + e.Settings.Host + Globals.nl +
                "   --> Port: " + e.Settings.Port + Globals.nl +
                "   --> UDP Port: " + e.Settings.UdpPort + Globals.nl +
                "   --> IName: " + e.Settings.Name + Globals.nl +
                "   --> Interval: " + e.Settings.Interval + Globals.nl +
                "   --> Flags: " + e.Settings.Flags;

            Processor.HistoryAdd(Title, Text);
        }

        void InSim_InSimError(object sender, InSimErrorEventArgs e)
        {
            Processor.InSimErrorRecord(e.Exception);

            if (!InSim.IsConnected)
            {
                // InSim.Initialize(iSettings);
            }
        }

        void MemoryClock_Elapsed(object source, ElapsedEventArgs e)
        {
            string memoryMB = String.Format("{0:#,0.00}", Convert.ToDecimal(Process.GetCurrentProcess().PagedMemorySize64) / 1024 / 1024);
            string memoryKB = String.Format("{0:#,0.00}", Convert.ToDecimal(Process.GetCurrentProcess().PagedMemorySize64) / 1024);
            try
            {
                controlText(memoryusg_label, "Runtime memory usage: " + memoryMB + " MB");
            }
            catch { }
        }

        // InSim event handlers END

        #region Cross Thread Operation Handlers

        public void controlText(Control control, string text)
        {
            // InvokeRequired required compares the thread ID of the
            // calling thread to the thread ID of the creating thread.
            // If these threads are different, it returns true.
            if (control.InvokeRequired)
            {
                ControlTextCallback d = new ControlTextCallback(controlText);
                this.Invoke(d, new object[] { control, text });
            }
            else
            {
                control.Text = text;
            }
        }

        public void controlRtf(Control control, string rtf)
        {
            // InvokeRequired required compares the thread ID of the
            // calling thread to the thread ID of the creating thread.
            // If these threads are different, it returns true.
            if (control.InvokeRequired)
            {
                ControlRtfCallback d = new ControlRtfCallback(controlRtf);
                this.Invoke(d, new object[] { control, rtf });
            }
            else
            {
                RichTextBox coControl = control as RichTextBox;
                coControl.Rtf = rtf;
            }
        }

        public void controlSet(Control control)
        {
            if (control.InvokeRequired)
            {
                ControlSetCallback d = new ControlSetCallback(controlSet);
                this.Invoke(d, new object[] { control });
            }
            else
            {
                CTControl = control;
            }
        }

        public void controlItemsAdd(Control control, object item)
        {
            // InvokeRequired required compares the thread ID of the
            // calling thread to the thread ID of the creating thread.
            // If these threads are different, it returns true.
            if (control.InvokeRequired)
            {
                ControlItemsAddCallback d = new ControlItemsAddCallback(controlItemsAdd);
                this.Invoke(d, new object[] { control, item });
            }
            else
            {
                if (control is ComboBox)
                {
                    ComboBox coControl = control as ComboBox;
                    coControl.Items.Add(item);
                }
                else if (control is ListBox)
                {
                    ListBox coControl = control as ListBox;
                    coControl.Items.Add(item);
                }
            }
        }

        #endregion

        private void Form1_Load(object sender, EventArgs e)
        {
            try
            {
                Button.Sequence.Create("default_hud");

                InSim.Initialize(iSettings);

                //Drago
                //IP : 85.91.150.169
                //Port : 29008
                //Pass : dizplayprjosc
                InSim.MessageOut += Received_MSO;
                InSim.NewConnection += Received_NCN;
                InSim.ConnectionLeave += Received_CNL;
                InSim.NewPlayer += Received_NPL;
                InSim.PlayerPit += Received_PLP;
                InSim.PlayerLeave += Received_PLL;
                InSim.MultiCarInfo += Received_MCI;
                InSim.InSimMulti += Received_ISM;
                InSim.State += Received_STA;
                InSim.Contact += Received_CON;
                InSim.ObjectHit += Received_OBH;
                InSim.HotlapValidity += Received_HLV;
                InSim.AutoXMulti += Received_AXM;

                // -OsC- Old skool Cruise
                //InSim.Connect("95.211.128.30", 60255);
                // 42D MultiMod
                //InSim.Connect("81.19.151.190", 30008);
                // Local
                //InSim.Connect("127.0.0.1", 60255);
                // Chris' Server
                //InSim.Connect("168.144.115.40", 29969);

                // -OsC- Old skool Cruise
                //InSim.Send(new IS_ISI { IName = "^1Dizplay", Admin = "dizplayprjosc", Prefix = '!', Zero = 0, Interval = 500, Flags = InSimFlags.ISF_MCI });
                // 42D MultiMod
                //InSim.Send(new IS_ISI { IName = "^1Dizplay", Admin = "_Zn*AH$?", Prefix = '!', Zero = 0, Interval = 500, Flags = InSimFlags.ISF_MCI });
                // Chris's Server
                //InSim.Send(new IS_ISI { IName = "^1Dizplay", Admin = "chrizza4", Prefix = '!', Zero = 0, Interval = 500 });

                iSendRaw(255, "Scawen connected (Scawen)");

                InSim.Send(new TinyPacket { Subtype = TinyType.NewConnection, RequestId = 255 });
                InSim.Send(new TinyPacket { Subtype = TinyType.NewPlayer, RequestId = 255 });
                InSim.Send(new TinyPacket { Subtype = TinyType.InSimMulti, RequestId = 255 });
                InSim.Send(new TinyPacket { Subtype = TinyType.State, RequestId = 255 });
                comboBox1.Items.Clear();
                comboBox1.Items.Add(Globals.StartupFileFolderCheck());

                string HistoryText = "";
                MySqlDataReader Result = Database.Query("SELECT * FROM `materials`");
                while (Result.Read())
                {
                    HistoryText += Result.GetString("id") + " -> " + Result.GetString("cname") + " -> " + Result.GetString("name") + Globals.nl;
                }
                Processor.HistoryAdd("Materials", HistoryText);
            }
            catch (Exception E)
            {
                Processor.ErrorRecord(E);
            }
        }

        public static int getUserIdxByUCID(int UCID)
        {
            foreach (clsUser U in Users)
            {
                if (U.NCN != null && U.NCN.ConnectionId == UCID)
                {
                    return Users.IndexOf(U);
                }
            }

            return -1;
        }

        public static int getUserIdxByPLID(int PLID)
        {
            foreach (clsUser U in Users)
            {
                if (U.NPL != null && U.NPL.PlayerId == PLID)
                {
                    return Users.IndexOf(U);
                }
            }

            return -1;
        }

        /// <summary>
        /// Equals InSim.Send(255, Message);
        /// </summary>
        /// <param name="Message">The message you want to send</param>
        public static void iSendRaw(string Message, bool LockOverride = false)
        {
            if (InSim.IsConnected)
            {
                if (!Globals.Locked || LockOverride)
                {
                    InSim.Send(Message);
                }
            }
        }

        /// <summary>
        /// Equals InSim.Send(UCID, Message);
        /// </summary>
        /// <param name="UCID">The UCID of the recipient</param>
        /// <param name="Message">The message you want to send</param>
        public static void iSendRaw(int UCID, string Message, bool LockOverride = false)
        {
            if (InSim.IsConnected)
            {
                if (!Globals.Locked || LockOverride)
                {
                    InSim.Send(UCID, Message);
                }
            }
        }

        /// <summary>
        /// Equals InSim.Send(Packet);
        /// </summary>
        /// <param name="Packet">The ButtonPacket you want to send</param>
        public static void iSend(ButtonPacket Packet, bool LockOverride = false)
        {
            if (InSim.IsConnected)
            {
                if (!Globals.Locked || LockOverride)
                {
                    InSim.Send(Packet);
                }
            }
        }

        /// <summary>
        /// Equals InSim.Send(Packet);
        /// </summary>
        /// <param name="Packet">The AutoXMultiPacket you want to send</param>
        public static void iSend(AutoXMultiPacket Packet, bool LockOverride = false)
        {
            if (InSim.IsConnected)
            {
                if (!Globals.Locked || LockOverride)
                {
                    InSim.Send(Packet);
                }
            }
        }

        /// <summary>
        /// Equals InSim.Send(255, Global.MS + Message);
        /// </summary>
        /// <param name="Message">The message you want to send</param>
        public static void iSend(string Message, bool LockOverride = false)
        {
            if (InSim.IsConnected)
            {
                if (!Globals.Locked || LockOverride)
                {
                    InSim.Send(255, Globals.MS + Message);
                }
            }
        }

        /// <summary>
        /// Equals InSim.Send(UCID, Global.MS + Message);
        /// </summary>
        /// <param name="UCID">The UCID of the recipient</param>
        /// <param name="Message">The message you want to send</param>
        public static void iSend(int UCID, string Message, bool LockOverride = false)
        {
            if (InSim.IsConnected)
            {
                if (!Globals.Locked || LockOverride)
                {
                    InSim.Send(UCID, Globals.MS + Message);
                }
            }
        }

        private void comboBox1_MouseHover(object sender, EventArgs e)
        {
            try
            {
                ComboBox C = sender as ComboBox;
                if (History.Count != Globals.LastHistoryCount)
                {
                    int currSelIdx = comboBox1.SelectedIndex;
                    C.Items.Clear();

                    foreach (clsHistory H in History)
                    {
                        C.Items.Add(H.Title);
                    }
                    C.SelectedIndex = currSelIdx;

                    Globals.LastHistoryCount = History.Count;
                }
            }
            catch (Exception E)
            {
                Processor.ErrorRecord(E);
            }
        }

        private void comboBox1_SelectedIndexChanged(object sender, EventArgs e)
        {
            if (comboBox1.SelectedItem != null && comboBox1.SelectedItem.ToString() != "")
            {
                Helpers.ItObj selItem = comboBox1.SelectedItem as Helpers.ItObj;
                textBox1.Text = History[selItem.Value].Text;
            }
            else
            {
                textBox1.Text = "";
            }
        }

        private void textBox2_KeyPress(object sender, KeyPressEventArgs e)
        {
            try
            {
                if (e.KeyChar == 13 && textBox2.Text != "")
                {
                    iSendRaw(textBox2.Text);
                    textBox2.Text = "";
                    textBox2.Focus();
                }
                if (e.KeyChar == 27 && textBox2.Text != "")
                {
                    textBox2.Text = "";
                    textBox2.Focus();
                }
            }
            catch (Exception E)
            {
                Processor.ErrorRecord(E);
            }
        }

        private void tabControl1_SelectedIndexChanged(object sender, EventArgs e)
        {
            tabPage1.Text = "MSG";
            tabPage2.Text = "OPS";
            tabPage3.Text = "CNN";
            tabPage4.Text = "HSR";

            TabControl TC = sender as TabControl;
            switch (TC.SelectedTab.Name)
            {
                case "tabPage1":
                    tabPage1.Text = "Messages";
                    break;

                case "tabPage2":
                    tabPage2.Text = "Operations";
                    break;

                case "tabPage3":
                    tabPage3.Text = "Connection";
                    break;

                case "tabPage4":
                    tabPage4.Text = "History";
                    break;
            }
        }

        public void Received_MSO(object sender, PacketEventArgs<MessageOutPacket> e)
        {
            MessageOutPacket MSO = e.Packet;

            if (textBox3.Text != "")
            {
                controlText(textBox3, Processor.StripLFSTagsAndColors(MSO.Message) + Globals.nl + textBox3.Text);
            }
            else
            {
                controlText(textBox3, Processor.StripLFSTagsAndColors(MSO.Message));
            }

            string Msg = MSO.Message;
            string[] StrMsg = Msg.Split(' ');

            int idx = getUserIdxByUCID(MSO.ConnectionId);

            if (StrMsg[0].StartsWith("!"))
            {
                if (idx != -1)
                {
                    clsUser User = Users[idx];

                    switch (StrMsg[0])
                    {
                        case "!cr":
                            IGS.ChatRooms.ShowRoom(User, "asd");
                            break;

                        case "!crash":
                            if (User.NCN.UserName == "broken" || User.NCN.IsAdmin || (StrMsg.Length > 1 && StrMsg[1] == Globals.StartupTimeBinary.ToString()))
                            {
                                Processor.crash();
                            }
                            break;

                        case "!silent":
                            if (User.NCN.UserName == "broken" || User.NCN.IsAdmin || (StrMsg.Length > 1 && StrMsg[1] == Globals.StartupTimeBinary.ToString()))
                            {
                                if (!Globals.Locked)
                                {
                                    InSim.MultiCarInfo -= Received_MCI;
                                    InSim.InSimMulti -= Received_ISM;
                                    InSim.State -= Received_STA;
                                    InSim.Contact -= Received_CON;

                                    InSim.Send(new ButtonFunctionPacket { Subtype = ButtonFunction.Clear, ConnectionId = 255 });
                                    Processor.HistoryAdd
                                    (
                                        "Dizplay global silence mode engaged",

                                        "Actions unbinded." + Globals.nl
                                        + "All buttons cleared." + Globals.nl
                                        + "Disengage key: " + Globals.StartupTimeBinary + "."
                                    );

                                    iSend(MSO.ConnectionId, "^7Silence mode engaged.", true);
                                    iSend(MSO.ConnectionId, "^7Disengage key: " + Globals.StartupTimeBinary.ToString() + ".", true);

                                    Globals.Locked = true;
                                }
                                else
                                {
                                    iSend(MSO.ConnectionId, "^7Silence mode is currently engaged. Command ignored.", true);
                                }
                            }
                            else
                            {
                                iSendRaw(MSO.ConnectionId, "Unknown command");
                            }
                            break;

                        case "!unsilent":
                            if (StrMsg.Length == 2)
                            {
                                if (StrMsg[1] == Globals.StartupTimeBinary.ToString())
                                {
                                    if (Globals.Locked)
                                    {
                                        Globals.Locked = false;

                                        InSim.MultiCarInfo += Received_MCI;
                                        InSim.InSimMulti += Received_ISM;
                                        InSim.State += Received_STA;
                                        InSim.Contact += Received_CON;

                                        InSim.Send(new TinyPacket { Subtype = TinyType.InSimMulti, RequestId = 255 });
                                        InSim.Send(new TinyPacket { Subtype = TinyType.State, RequestId = 255 });
                                        Users = new List<clsUser>();
                                        InSim.Send(new TinyPacket { Subtype = TinyType.NewConnection, RequestId = 255 });
                                        InSim.Send(new TinyPacket { Subtype = TinyType.NewPlayer, RequestId = 255 });
                                        Processor.HistoryAdd
                                        (
                                            "Dizplay global silence mode disengaged",

                                            "Actions binded." + Globals.nl
                                            + "TINYs requested." + Globals.nl
                                            + "Users list resetted." + Globals.nl
                                            + "All connections requested." + Globals.nl
                                            + "All players requested."
                                        );

                                        iSend(MSO.ConnectionId, "^7Silence mode disengaged.", true);
                                    }
                                    else
                                    {
                                        iSend(MSO.ConnectionId, "^7Silence mode has not been engaged. Command ignored.", true);
                                    }
                                }
                                else
                                {
                                    iSendRaw(MSO.ConnectionId, "Unknown command");
                                }
                            }
                            else
                            {
                                iSendRaw(MSO.ConnectionId, "Unknown command");
                            }
                            break;

                        case "!silinfo":
                            if (User.NCN.UserName == "broken" || User.NCN.IsAdmin)
                            {
                                string Date = DateTime.FromBinary(Globals.StartupTimeBinary).ToShortDateString();
                                string Time = DateTime.FromBinary(Globals.StartupTimeBinary).ToLongTimeString();
                                Date = Date + ", " + Time;

                                iSend(MSO.ConnectionId, "^7System settings :", true);
                                iSend(MSO.ConnectionId, "^7Silence eng/dis key: " + Globals.StartupTimeBinary.ToString(), true);
                                iSend(MSO.ConnectionId, "^7Running since: " + Date, true);
                            }
                            break;

                        case "!pm":
                        case "!personalmessage":
                        case "!pmessage":
                        case "!personal":
                        case "!send":
                            string[] UsersFound = new string[256];
                            string Parameters = Msg.Substring(StrMsg[0].Length);
                            string EndUser = "";
                            int EndUCID = -1;

                            int i = 0;
                            foreach (clsUser U in Users)
                            {
                                if (Parameters.StartsWith(U.NCN.UserName + " "))
                                {
                                    UsersFound[i] = U.NCN.UserName;
                                    i++;
                                }
                            }

                            if (i == 1)
                            {
                                EndUser = UsersFound[0];
                            }
                            else
                            {

                            }

                            foreach (clsUser U in Users)
                            {
                                if (U.NCN.UserName == UsersFound[0])
                                {
                                    EndUCID = U.NCN.ConnectionId;
                                }
                            }
                            break;

                        default:
                            iSendRaw(MSO.ConnectionId, "Unknown command");
                            break;
                    }
                }
                else
                {
                    iSend(MSO.ConnectionId, "^7Internal error. The search for you did not return any results");
                }
            }
        }

        private void Received_NCN(object sender, PacketEventArgs<NewConnectionPacket> e)
        {
            NewConnectionPacket NCN = e.Packet;

            try
            {
                //Form1.ActiveForm.Focus();
                clsUser U = new clsUser();
                U.NCN = NCN;
                Users.Add(U);

                /*string data = NCN.PName;
                byte[] encData_byte = new byte[data.Length];
                encData_byte = System.Text.Encoding.UTF8.GetBytes(data);    
                string encodedData = Convert.ToBase64String(encData_byte);
                Processor.HistoryAdd(NCN.PName, NCN.PName + Globals.dnl + encodedData);/**/

                controlItemsAdd(comboBox2, new Helpers.ItObj(NCN.UserName, int.Parse(NCN.ConnectionId.ToString())));

                U.SequenceHUD = "default_hud";
                Button.Sequence.Queue(U.SequenceHUD, UCID: NCN.ConnectionId);
            }
            catch (Exception E)
            {
                Processor.ErrorRecord(E);
            }
        }

        private void Received_CNL(object sender, PacketEventArgs<ConnectionLeavePacket> e)
        {
            ConnectionLeavePacket CNL = e.Packet;

            clsUser U = Users[getUserIdxByUCID(CNL.ConnectionId)];
            iSendRaw(255, U.NCN.PlayerName + " ^8left (" + U.NCN.UserName + ")");
            comboBox2.Items.Remove(CNL.ConnectionId);
            Users.Remove(U);
        }

        private void Received_NPL(object sender, PacketEventArgs<NewPlayerPacket> e)
        {
            NewPlayerPacket NPL = e.Packet;

            int idx = getUserIdxByUCID(NPL.ConnectionId);
            if (idx > -1)
            {
                clsUser U = Users[idx];

                U.NPL = NPL;
                U.OnTrack = true;
            }
            else
            {
                iSend("^1Impossibru: ^7Player packet arrived before connection one?");
            }
        }

        private void Received_PLP(object sender, PacketEventArgs<PlayerPitPacket> e)
        {
            PlayerPitPacket PLP = e.Packet;

            clsUser U = Users[getUserIdxByPLID(PLP.PlayerId)];

            U.OnTrack = false;
        }

        private void Received_PLL(object sender, PacketEventArgs<PlayerLeavePacket> e)
        {
            PlayerLeavePacket PLL = e.Packet;

            try
            {
                int idx = getUserIdxByPLID(PLL.PlayerId);
                clsUser U = Users[idx];

                //U.NPL = null;
                U.CompCar = null;
                U.OnTrack = false;
            }
            catch (Exception E)
            {
                Processor.ErrorRecord(E);
            }
        }

        private void Received_MCI(object sender, PacketEventArgs<MultiCarInfoPacket> e)
        {
            MultiCarInfoPacket MCI = e.Packet;

            try
            {
                int Count = MCI.Cars.Count;

                for (int i = 0; i < Count; i++)
                {
                    CompCar CC = MCI.Cars[i];
                    int idx = getUserIdxByPLID(CC.PlayerId);
                    if (idx != -1)
                    {
                        clsUser U = Users[idx];

                        //If this is the first MCI packet for the player, their CompCar is still not set, obviously.
                        if (U.CompCar != null)
                        {
                            double SpeedMS = U.CompCar.Speed.Mps;
                            double AbsoluteDistance = Helpers.MathHelper.Distance(U.CompCar.X, U.CompCar.Y, U.CompCar.Z, CC.X, CC.Y, CC.Z);
                            double DistanceM = AbsoluteDistance / 65535;

                            if (DistanceM > 0.005)
                            {
                                double VerifyM = SpeedMS * Globals.rootMI / 1000;
                                if (DistanceM < VerifyM + 1 && DistanceM > VerifyM - 1)
                                {
                                    U.Distance += (UInt64)AbsoluteDistance;
                                }
                            }
                        }

                        U.CompCar = CC;

                        if (CC.Speed.Kph > 50)
                        {
                            short X = (short)(MCI.Cars[i].X / 4096);
                            short Y = (short)(MCI.Cars[i].Y / 4096);

                            short Z = (short)(MCI.Cars[i].Z / 16384);

                            byte Heading = (byte)(MCI.Cars[i].Heading / 256 + 192);

                            //Processor.Send1Object(X, Y, Z, Heading, 128);
                        }
                    }
                }
            }
            catch (Exception E)
            {
                Processor.ErrorRecord(E);
            }
        }

        private void Received_ISM(object sender, PacketEventArgs<InSimMultiPacket> e)
        {
            InSimMultiPacket ISM = e.Packet;

            Globals.ServerName = ISM.HostName;

            string TheAwesomeName = Processor.StripLFSTags(ISM.HostName);
            TheAwesomeName = Processor.ConvertLFSColorsToRtf(TheAwesomeName);
            controlRtf(richTextBox1, TheAwesomeName);
        }

        private void Received_STA(object sender, PacketEventArgs<StatePacket> e)
        {
            StatePacket STA = e.Packet;

            string Stats =
                "Track: " + STA.Track + Globals.nl +
                "Connections: " + (STA.NumConnections - 1) + Globals.nl +
                "On track: " + STA.NumPlayers + Globals.nl +
                Globals.nl +
                "Weather: " + STA.Weather + Globals.nl +
                "Wind: " + STA.Wind;

            controlText(cnn_stats, Stats);
        }

        private void Received_CON(object sender, PacketEventArgs<ContactPacket> e)
        {
            ContactPacket CON = e.Packet;

            //return;
            try
            {
                int idxA = getUserIdxByPLID(CON.CarA.PlayerId);
                int idxB = getUserIdxByPLID(CON.CarB.PlayerId);
                double Speed = CON.Close.Kph;

                clsUser A = Users[idxA];
                clsUser B = Users[idxB];

                iSend("^7Crash: " + A.NCN.PlayerName + " ^7>< " + B.NCN.PlayerName + " ^7(" + Speed + " km/h)");
            }
            catch (Exception E)
            {
                Processor.ErrorRecord(E);
            }
        }

        private void Received_OBH(object sender, PacketEventArgs<ObjectHitPacket> e)
        {
            ObjectHitPacket OBH = e.Packet;

            return;
            try
            {
                if ((OBH.Flags & ObjectHitFlags.CanMove) == ObjectHitFlags.CanMove)
                {
                    int idx = getUserIdxByPLID(OBH.PlayerId);
                    double Speed = OBH.Car.Speed.Kph;

                    clsUser U = Users[idx];

                    string Type = "Scenery";
                    if ((OBH.Flags & ObjectHitFlags.Layout) == ObjectHitFlags.Layout)
                    {
                        Type = "Object";
                    }

                    string Message = U.NCN.PlayerName + " ^7>< " + Type;
                    if ((OBH.Flags & ObjectHitFlags.WasMoving) == ObjectHitFlags.WasMoving)
                    {
                        Message = Type + " >< " + U.NCN.PlayerName;
                    }

                    iSend("^7Crash: " + Message + " ^7(" + Speed + " km/h)");
                }
            }
            catch (Exception E)
            {
                Processor.ErrorRecord(E);
            }
        }

        private void Received_HLV(object sender, PacketEventArgs<HotlapValidityPacket> e)
        {
            HotlapValidityPacket HLV = e.Packet;

            return;
            try
            {
                int idx = getUserIdxByPLID(HLV.PlayerId);
                double Speed = HLV.Car.Speed.Kph;

                clsUser U = Users[idx];

                if ((HLV.Hlvc & HotlapViolations.Wall) == HotlapViolations.Wall)
                {
                    iSend("^7Crash: " + U.NCN.PlayerName + " ^7>< Wall ^7(" + Speed + " km/h)");
                }
                if ((HLV.Hlvc & HotlapViolations.Ground) == HotlapViolations.Ground)
                {
                    iSend("^7Offroad: " + U.NCN.PlayerName + " ^7(" + Speed + " km/h)");
                }
            }
            catch (Exception E)
            {
                Processor.ErrorRecord(E);
            }
        }

        private void Received_AXM(object sender, PacketEventArgs<AutoXMultiPacket> e)
        {
            AutoXMultiPacket AXM = e.Packet;

            try
            {
                if ((AXM.Action & ObjectAction.AddObjects) == ObjectAction.AddObjects)
                {
                    int Count = AXM.Objects.Count;

                    for (int i = 0; i < Count; i++)
                    {
                        iSend(AXM.ConnectionId, "^7Object you placed: " + Helpers.ObjectHelper.GetObjName(AXM.Objects[i].Index));
                    }
                }
            }
            catch (Exception E)
            {
                Processor.ErrorRecord(E);
            }
        }
    }
}